
import { Metadata } from 'next'
import { auth } from '@/auth';
import { getDash } from '@/actions/data/getDash';
import { getCalendar } from '@/actions/data/getCalendar';

import MainDashboard from '@/components/dashboard/main-dashboard';
import ClientOnly from '@/components/web/client-only';

//for testing
import { promises as fs } from 'fs';
import { getCurrentUser } from '@/actions/profile/getUser';

import { Suspense } from 'react';
import Loader from '@/components/web/loader';


export const metadata: Metadata = {
    title: 'Dashboard Bali Management Villas',
    description: 'The Dashboard Owner by Bali Management Villas',
    robots: {
        index: false,
        follow: false,
    },
    icons: {
        icon: '/bmv-favicon.png',
        shortcut: '/bmv-favicon.png',
        apple: '/bmv-favicon.png',
        other: {
            rel: 'apple-touch-icon-precomposed',
            url: '/bmv-favicon.png',
        },
    },
    metadataBase: new URL('https://dash.balimanagement.villas'),
    alternates: {
        canonical: '/',
        languages: {
            'en-US': '/',
            'de-DE': '/de-DE',
            'id-ID': '/id-ID'
        },
    },
    openGraph: {
        images: '/og-picture.png',
    },
    manifest: "/manifest.json",
}

export const revalidate = 0

export default async function Home({params}: {params: {locale: any}}) {
    const session = await auth()

    const dashData = await getDash()
    // const fileDash = await fs.readFile(process.cwd() + '/lib/dashboard.json', 'utf8');
    // const dashData = JSON.parse(fileDash);

    const userData = await getCurrentUser()
    // const fileUser = await fs.readFile(process.cwd() + '/lib/user.json', 'utf8');
    // const userData = JSON.parse(fileUser);
    
    const calendarData = await getCalendar()
    // const file = await fs.readFile(process.cwd() + '/lib/calendar.json', 'utf8');
    // const calendarData = JSON.parse(file);
    return (
        <ClientOnly>
            <Suspense fallback={<Loader />}>
                <MainDashboard 
                    users={userData}
                    villas={session?.user?.user.villa} 
                    tokens={session?.accessToken}
                    defaultDash={dashData}
                    defaultBooking={calendarData?.data.bookings.events}
                    defaultCalendar={calendarData?.data.bookings}
                    defaultLive={calendarData?.data.live}
                    defaultMetrics={calendarData?.data.metrics}
                />
            </Suspense>
            {/* <pre className='text-white bg-black p-4 h-screen w-screen overflow-y-auto'>
                {JSON.stringify(session, null, 2)}
            </pre> */}
        </ClientOnly>
    );
}
